use [PearsonLearning70-767]

-- Invoice Line Fact
select * from [PearsonLearning70-767].dbo.factInvoiceLine

-- Check Partitions
select	o.name objectname,i.name indexname, partition_id, partition_number, [rows]
from	sys.partitions p
		inner join sys.objects o ON o.object_id=p.object_id
		inner join sys.indexes i ON i.object_id=p.object_id and p.index_id=i.index_id
where	o.name = 'factInvoiceLine'

-- Create Clustered Index with Partition
create clustered index IX_factInvoiceLine_partition on [PearsonLearning70-767].dbo.factInvoiceLine
	(
	invoiceDate
	)
	on ps_primary(invoiceDate)
go

-- Create Partition Functions
create partition function pf_annualInvoiceLeft (Date) as range left for values ('2013-01-01', '2014-01-01', '2015-01-01', '2016-01-01')
create partition function pf_annualInvoiceRight (Date) as range right for values ('2013-12-31', '2014-12-31', '2015-12-31', '2016-12-31')

-- Create Partition Scheme
create partition scheme ps_primary as partition pf_annualInvoiceRight all to ([Primary])

-- Check Partitions
select	o.name objectname,i.name indexname, partition_id, partition_number, [rows]
from	sys.partitions p
		inner join sys.objects o ON o.object_id=p.object_id
		inner join sys.indexes i ON i.object_id=p.object_id and p.index_id=i.index_id
where	o.name = 'factInvoiceLine'

-- select from partitioned table
select * from dbo.factInvoiceLine where invoiceDate = '2014-01-01'
